---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Saturated Field (classification)

> Overloaded observation/propagation regime where differences become indistinguishable beyond capacity.

---

## Definition

- Input/throughput exceeds capacity; effective indistinguishability results
- Too many signals blur into noise
- Phase coherence lost under load

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Saturation | Overload | `Monitor`, `Limit` |
| Capacity | Resource bound | `Measure`, `Quota` |
| Blur | Signal loss | `Noise`, `SNR` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Saturation | Overwhelm | "Too much to handle" |
| Capacity | Natural limit | "Can't take more" |
| Blur | Lost clarity | "All blends together" |

### Crosswalk (bridge)

| Technical term | Humane term | Diagnostic meaning |
|---------------|-------------|-------------------|
| Overload | Overwhelm | Beyond capacity |
| Resource bound | Natural limit | What we can handle |
| Signal loss | Lost clarity | How detail fades |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Detector saturation | Signal overload |
| Networks | Bandwidth limit | Connection flood |
| Cognition | Memory overflow | Mental overwhelm |
| Systems | Resource exhaustion | System overload |

---

## Scale Effects

How Saturated Field manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum blur | Wave packet |
| λV | State flood | Energy blur |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase loss | Pattern blur |
| ∇S | Structure flood | Boundary loss |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal flood | Information horizon |
| λV | Field saturation | Cosmic density |

Note: At extreme scales, saturation can become indistinguishable from fundamental limits (e.g., quantum uncertainty at ε, cosmic density at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: too many sub-ε fluctuations as noise
- c: propagation/processing ceiling exceeded
- λV: gate flood or starvation oscillation
- ψA: phase coherence lost under load

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Structure flood | Pattern loss |
| Human | λV | Gate overload | Boundary blur |
| Cosmic | ψA | Phase break | Lost coherence |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Noise flood | Signal drowning | Lost detail |
| Human | Capacity break | Resource exhaust | Overwhelm |
| Cosmic | Phase loss | Coherence break | Lost binding |

---

## Diagnostic Checklist

Technical tests:
- [ ] Load vs capacity within bounds
- [ ] Signal distinguishability check
- [ ] Phase/latency jitter measure
- [ ] Resource monitoring

Humane tests:
- [ ] Clear vs overwhelmed feeling
- [ ] Pattern recognition possible
- [ ] Natural flow maintained
- [ ] Comfortable processing

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical overload metrics nor experiential overwhelm alone captures its full meaning.

---

## See Also

- [[Transparent Field (classification)]]
- [[Masked Field (classification)]]
- [[Sparse Field (classification)]]
- [[Field]]
- [[Void]]
- [[Capacity Margin (diagnostic)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented